const { GoogleGenerativeAI } = require('@google/generative-ai');
const readline = require('readline');
const fs = require('fs').promises;
const path = require('path');

const rl = readline.createInterface({
  input: process.stdin,
  output: process.stdout
});

const genAI = new GoogleGenerativeAI(process.env.API_KEY);

async function run() {
  const model = genAI.getGenerativeModel({ model: 'gemini-1.5-flash' });
  const companyDataPath = path.join(__dirname, 'company-data.txt');
  const companyData = await fs.readFile(companyDataPath, 'utf8');

  const chat = model.startChat({
    generationConfig: {
      maxOutputTokens: 500,
    },
  });

  async function askAndRespond() {
    rl.question('You: ', async (msg) => {
      if (msg.toLowerCase() === 'exit') {
        rl.close();
        return;
      }

      const userMessage = `You are a helpful assistant for the company Cogitel. Answer the user's questions based on the following information:\n\n${companyData}\n\n---\n\nQuestion: ${msg}`;
      const result = await chat.sendMessage(userMessage);
      const response = await result.response;
      const text = response.text();
      console.log('Chatbot: ', text);
      askAndRespond();
    });
  }

  console.log('Chatbot: I am ready. Ask me anything about the company.');
  askAndRespond();
}

run();
